IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CP_Cbtes_Rem_Generar_Item') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CP_Cbtes_Rem_Generar_Item
END
GO

CREATE PROCEDURE [dbo].[CP_Cbtes_Rem_Generar_Item]
@pId_Trans		INT,			/*Cbtes*/
@pId_Producto	VARCHAR(14),	/*Productos*/
@pCantidad		DECIMAL(12,4),
@pObservacion	VARCHAR(8000),
@pFecha_QA		DATETIME,
@pFecha_Venc	DATETIME,
@pPrecio_Grav 	DECIMAL(20, 5), /*Precio Sin IVA*/
@pPorc_Iva 		DECIMAL(5, 2), /*Porcentaje de IVA*/
@pBonif			DECIMAL(5, 2),
@pId_Cliente	INT				/*Clientes*/
AS

DECLARE @Trans TABLE (ErrorNumber	INT 
					,ErrorSeverity  INT 
					,ErrorState		INT
					,ErrorProcedure	VARCHAR(100)
					,ErrorLine		INT
					,ErrorMessage	VARCHAR(1000)
					,Item			SMALLINT)

/*Declaracion Variables Locales*/
DECLARE @Item 					SMALLINT
DECLARE @Id_Estado_Cbte 		SMALLINT
DECLARE @Calle 					CHAR(5)
DECLARE @Columna 				CHAR(5)
DECLARE @Fila 					CHAR(5)
DECLARE @Bultos 				DECIMAL(15, 5)
DECLARE @Despacho 				VARCHAR(100)
DECLARE @Serie 					VARCHAR(100)
DECLARE @Millas 				INT
DECLARE @Cantidad_Saldo 		DECIMAL(15, 5)
DECLARE @Precio_Exen 			DECIMAL(20, 5)
DECLARE @Imp_Gravado 			DECIMAL(20, 2)
DECLARE @Imp_Exento 			DECIMAL(20, 2)
DECLARE @Analisis 				VARCHAR(30)
DECLARE @Lote 					VARCHAR(20)
DECLARE @Flag_QA 				CHAR(1)
DECLARE @Descripcion_producto 	VARCHAR(100)
DECLARE @Id_Unidad_Medida 		CHAR(4)
DECLARE @Imp_Final				DECIMAL(20,5)
DECLARE @Costo 					DECIMAL(20, 5)
DECLARE @Imp_Iva 				DECIMAL(20, 2)
DECLARE @Precio 				DECIMAL(20, 5)
DECLARE @Id_Costo 				INT
DECLARE @Id_Tarea 				SMALLINT
DECLARE @Fecha_Caducidad 		DATETIME
DECLARE @Id_Pais 				CHAR(3)
DECLARE @Id_Usuario 			SMALLINT
DECLARE @Cantidad_Equiv 		DECIMAL(15, 5)
DECLARE @Costo_MO 				DECIMAL(20, 5)
DECLARE @Costo_GF 				DECIMAL(20, 5)
DECLARE @Id_Cond_Pago 			SMALLINT
DECLARE @Fecha_Proceso 			DATETIME
DECLARE @Id_Balanza 			CHAR(10)
DECLARE @Orden 					SMALLINT
DECLARE @Flag_NoImp_Factura 	TINYINT
DECLARE @Nro_Tag 				VARCHAR(30)
DECLARE @Fecha_Elaboracion 		DATETIME
DECLARE @Costo_Comparativo 		DECIMAL(13, 4)
DECLARE @Porc_Imp_Int 			DECIMAL(5, 2)
DECLARE @Id_Cta_Banco 			SMALLINT
DECLARE @Flag_Existe_Trans		TINYINT
DECLARE @Flag_Existe_Cliente	TINYINT
DECLARE @Flag_Existe_Producto	TINYINT

DECLARE @Id_Lista_Precio		SMALLINT
DECLARE @Precio_Gravado_Producto DECIMAL(20, 5)

DECLARE @Mensaje				VARCHAR(100)
/*Fin de Declaraciones Variables Locales */

PRINT 'Procedimiento: CP_Cbtes_Rem_Generar_Item'

BEGIN TRY
	BEGIN TRAN

	SET @Flag_Existe_Trans = ISNULL((SELECT 1 FROM Cbtes WHERE Id_Trans = @pId_Trans), 0)
	IF (@Flag_Existe_Trans = 0)
	BEGIN
		SET @Mensaje = 'No existe la Transaccion'

		SELECT	2001			AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@Mensaje		AS ErrorMessage
				,@Item			AS Item
		ROLLBACK
		RETURN
	END

	SET @Flag_Existe_Cliente = ISNULL((SELECT 1 FROM Clientes WHERE Id_Cliente = @pId_Cliente), 0)
	IF (@Flag_Existe_Cliente = 0)
	BEGIN
		SET @Mensaje = 'No existe el Cliente'

		SELECT	2002			AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@Mensaje		AS ErrorMessage
				,@Item			AS Item
		ROLLBACK
		RETURN
	END

	/*************************************************************************************************/

	SET @Flag_Existe_Cliente = ISNULL((SELECT 1 FROM Clientes WHERE Id_Cliente = @pId_Cliente AND ISNULL(Activo, 0) = 1), 0)
	IF (@Flag_Existe_Cliente = 0)
	BEGIN
		SET @Mensaje = 'El Cliente esta Inactivo'

		SELECT	2003			AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@Mensaje		AS ErrorMessage
				,@Item			AS Item
		ROLLBACK
		RETURN
	END

	/*************************************************************************************************/

	SET @Flag_Existe_Producto = ISNULL((SELECT 1 FROM Productos WHERE Id_Producto = @pId_Producto), 0)
	IF (@Flag_Existe_Producto = 0)
	BEGIN
		SET @Mensaje = 'No existe el producto'

		SELECT	2004			AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@Mensaje		AS ErrorMessage
				,@Item			AS Item
		ROLLBACK
		RETURN
	END

	/*************************************************************************************************/

	SELECT  @Id_Estado_Cbte	= ISNULL(Id_Estado_Cbte, 0),
			@Lote			= ISNULL(Lote, ''),
			@Id_Usuario		= ISNULL(Id_Usuario, '-1')
	FROM Cbtes
	WHERE 
	Id_Trans = @pId_Trans

	/*************************************************************************************************/

	SELECT  @Calle					= ISNULL(Calle, ''),
			@Columna				= ISNULL(Columna, ''),
			@Fila					= ISNULL(Fila, ''),
			@Despacho				= ISNULL(Despacho, ''),
			@Descripcion_producto	= ISNULL(Descripcion_Resumida, ''),
			@Id_Unidad_Medida		= ISNULL(Id_Unidad_Medida, ''),
			@Costo					= ISNULL(Costo, 0),
			@Id_Cond_Pago			= ISNULL(Id_Cond_Pago, 0),
			@Id_Cta_Banco			= ISNULL(Id_Cta_Banco, 0),
			@Precio_Gravado_Producto = ISNULL(Precio_Gravado, 0)
	FROM Productos
	WHERE 
	Id_Producto = @pId_Producto	

	/*************************************************************************************************/	

	/*2018-10-31: Si el precio que se pasa es cero entonces busca en el producto o en la lista de precio del cliente el producto*/
	IF(@pPrecio_Grav = 0)
	BEGIN
		SET @Id_Lista_Precio = ISNULL((SELECT ISNULL(Id_Lista_Precio, 0) FROM Clientes WHERE Id_Cliente = @pId_Cliente), 0)

		IF(@Id_Lista_Precio = 0)
		BEGIN
			SET @pPrecio_Grav = @Precio_Gravado_Producto
		END
		ELSE
		BEGIN
			SET @pPrecio_Grav = ISNULL((SELECT ISNULL(Precio,0) FROM Prod_Listas_Precios_Items WHERE Id_Lista_Precio = @Id_Lista_Precio AND Id_Producto = @pId_Producto), 0)
		END
	END

	/*************************************************************************************************/

	SET @Item 					= (ISNULL((SELECT MAX(ISNULL(Item, 0)) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans), 0)) + 1
	SET @Bultos 				= 0
	SET @Serie 					= ''
	SET @Millas 				= 0
	SET @Cantidad_Saldo 		= @pCantidad
	SET @Precio_Exen 			= 0
	SET @Imp_Gravado 			= @pPrecio_Grav
	SET @Imp_Exento 			= @Precio_Exen
	SET @Analisis 				= ''
	SET @Flag_QA 				= 'A'
	SET @Imp_Iva 				= ((@pPrecio_Grav * @pPorc_Iva) / 100)
	SET @Imp_Final				= (@pPrecio_Grav + @Imp_Iva)
	SET @Precio 				= @pPrecio_Grav
	SET @Id_Costo 				= 0
	SET @Id_Tarea 				= 0
	SET @Fecha_Caducidad 		= NULL
	SET @Id_Pais 				= ''
	SET @Cantidad_Equiv 		= 0
	SET @Costo_MO 				= 0
	SET @Costo_GF 				= 0
	SET @Fecha_Proceso 			= NULL
	SET @Id_Balanza 			= ''
	SET @Orden 					= 0
	SET @Flag_NoImp_Factura 	= 0
	SET @Nro_Tag 				= ''
	SET @Fecha_Elaboracion 		= NULL
	SET @Costo_Comparativo 		= 0
	SET @Porc_Imp_Int 			= 0

	/*************************************************************************************************/

	INSERT INTO Cbtes_Items 
	(Id_Trans,		Item,					Id_Producto, 
	Id_Estado_Cbte, Cantidad,				Calle, 
	Columna,		Fila,					Bultos, 
	Despacho,		Serie,					Fecha_Venc,
	Observacion,	Millas,					Cantidad_Saldo, 
	Precio_Grav,	Precio_Exen,			Imp_Gravado, 
	Imp_Exento,		Analisis,				Lote, 
	Flag_QA,		Fecha_QA,				Porc_Iva, 
	Bonif,			Descripcion_producto,	Id_Unidad_Medida, 
	Imp_Final,		Costo,					Imp_Iva, 
	Precio,			Id_Costo,				Id_Cliente,
	Id_Tarea,		Fecha_Caducidad,		Id_Pais, 
	Id_Usuario,		Cantidad_Equiv,			Costo_MO, 
	Costo_GF,		Id_Cond_Pago,			Fecha_Proceso, 
	Id_Balanza,		Orden,					Flag_NoImp_Factura, 
	Nro_Tag,		Fecha_Elaboracion,		Costo_Comparativo, 
	Porc_Imp_Int,	Id_Cta_Banco)
	VALUES
	(@pId_Trans,		@Item,					@pId_Producto, 
	@Id_Estado_Cbte,	@pCantidad,				@Calle, 
	@Columna,			@Fila,					@Bultos, 
	@Despacho,			@Serie,					@pFecha_Venc,
	@pObservacion,		@Millas,				@Cantidad_Saldo, 
	@pPrecio_Grav,		@Precio_Exen,			@Imp_Gravado, 
	@Imp_Exento,		@Analisis,				@Lote, 
	@Flag_QA,			@pFecha_QA,				@pPorc_Iva, 
	@pBonif,			@Descripcion_producto,	@Id_Unidad_Medida, 
	@Imp_Final,			@Costo,					@Imp_Iva, 
	@Precio,			@Id_Costo,				@pId_Cliente,
	@Id_Tarea,			@Fecha_Caducidad,		@Id_Pais, 
	@Id_Usuario,		@Cantidad_Equiv,		@Costo_MO, 
	@Costo_GF,			@Id_Cond_Pago,			@Fecha_Proceso, 
	@Id_Balanza,		@Orden,					@Flag_NoImp_Factura, 
	@Nro_Tag,			@Fecha_Elaboracion,		@Costo_Comparativo, 
	@Porc_Imp_Int,		@Id_Cta_Banco)

	/*************************************************************************************************/
	
	COMMIT

	SET @Mensaje = @Descripcion_producto

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@Mensaje		AS ErrorMessage
			,@Item			AS Item

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH

PRINT 'FIN Procedimiento: CP_Cbtes_Rem_Generar_Item'
